from tkinter import *
import time

width = 750 # Longueur de l'ecran
height = 250 # Hauteur de l'ecran

# Creer le tk et le canvas
root=Tk()
root.title("Illusion de pieds")
root.geometry('%dx%d+%d+%d' % (width, height, 5, 135))
canvas=Canvas(root, width=width, height=height, bg="white")
canvas.grid()

# Constantes globales
lignAmount = 30 # Nombre de lignes sur l'ecran par defaut
lignWidth = width/(2*lignAmount) # Largeur d'une ligne
lignHeight = height # Hauteur d'une ligne
lignFill = "black"
rectangleAmount = 2 # Nombre de rectangles
rectangleWidth = 50 # Largeur d'un rectangle
rectangleHeight = 20 # Hauteur d'un rectangle
margin = 50 # Distance entre le haut de l'ecran et le premier rectangle
ligns = []

def drawLines():
    global ligns
    for lign in ligns:
        canvas.delete(lign)
    ligns = []
    for lignNumber in range(lignAmount):
        ligns.append(canvas.create_rectangle(lignNumber*2*lignWidth, 0, lignNumber*2*lignWidth+lignWidth, lignHeight, fill=lignFill, outline=""))
        canvas.tag_lower(ligns[-1])

rectangles = []
colors = ["yellow", "blue4", "red"]
for rectangleNumber in range(rectangleAmount):
    rectangles.append(canvas.create_rectangle(0, height/(rectangleAmount)*(rectangleNumber)+margin, rectangleWidth, height/(rectangleAmount)*(rectangleNumber)+rectangleHeight+margin, fill=colors[rectangleNumber], outline=""))

illusionOn = True

def clicked(event):
    global illusionOn, lignFill
    for lign in ligns:
        if illusionOn:
            lignFill = ""
        else:
            lignFill = "black"
    illusionOn = not illusionOn

# Click
canvas.bind("<Button 1>", clicked)

sliders=Tk()
speedSlider = Scale(sliders, from_=0, to=100, orient=HORIZONTAL)
speedSlider.pack()
speedSlider.set(50)
lignAmountSlider = Scale(sliders, from_=10, to=50, orient=HORIZONTAL)
lignAmountSlider.pack()
lignAmountSlider.set(lignAmount)
text = Entry(root, textvariable="Text")
text.bind("<Return>", lambda event: scale.configure(to="Text".get()))

while True:
    for rectangle in rectangles:
        coords = canvas.coords(rectangle)
        if coords[0] >= width:
            canvas.coords(rectangle, -rectangleWidth, coords[1], 0, coords[3])
        canvas.move(rectangle, 5, 0)
    lignAmount = lignAmountSlider.get()
    lignWidth = width/(2*lignAmount)
    drawLines()
    time.sleep((100-speedSlider.get())/500)
    canvas.update()

root.mainloop()
    
